<?php
session_start(); // Start the session

$banner250_300_var_adblocker = array('1', '2', '3', '4', '5');

// Check if the session variable for displayed banners is set; if not, initialize it
if (!isset($_SESSION['displayed_banners'])) {
    $_SESSION['displayed_banners'] = [];
}

// Get the available banners that have not been displayed
$available_banners = array_diff($banner250_300_var_adblocker, $_SESSION['displayed_banners']);

// If all banners have been displayed, reset the displayed banners
if (empty($available_banners)) {
    $_SESSION['displayed_banners'] = []; // Reset
    $available_banners = $banner250_300_var_adblocker; // Restore all banners
}

// Ensure we can get unique banners for each echo
$number_of_echos = 2; // Define how many times you want to echo different banners
$selected_banners = [];

// Select unique banners for output
for ($i = 0; $i < $number_of_echos; $i++) {
    if (!empty($available_banners)) {
        // Select a random one from the available banners
        $banner = $available_banners[array_rand($available_banners)];
        $selected_banners[] = $banner; // Store selected banner
        $_SESSION['displayed_banners'][] = $banner; // Store in session to avoid duplicates

        // Remove the selected banner from the available list to avoid future duplications in the same echo
        $available_banners = array_diff($available_banners, [$banner]);
    }
}

// Output the selected banners
foreach ($selected_banners as $banner) {
    echo $banner . '<br>'; // Use <br> for better readability
    echo $banner . '<br>'; // Use <br> for better readability
}
?>
