<?php
// Set a flag for ad blocker detection
$isAdBlockerDetected = false;

if (isset($_POST['adBlocker'])) {
    $isAdBlockerDetected = $_POST['adBlocker'] === 'true';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ad Blocker Detection</title>
    <script>
        function isHidden(e) { return "none" === window.getComputedStyle(e).display; }
        function hasClass(e, d) { return !!e.className.match(new RegExp("(\\s|^)" + d + "(\\s|$)")); }

        function adBlockerDetected(isBlocked) {
            // Use Fetch API to send the ad blocker status to the server
            fetch(window.location.href, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'adBlocker=' + (isBlocked ? 'true' : 'false')
            });
        }

        function checkAdBlock() {
            const testAd = document.createElement('div');
            testAd.innerHTML = '&nbsp;';
            testAd.className = 'adsbox'; // use class adBlockers look for
            document.body.appendChild(testAd);

            setTimeout(() => {
                const isBlocked = !testAd.offsetHeight; // Check if the ad is hidden
                adBlockerDetected(isBlocked);
                document.body.removeChild(testAd); // Clean up
            }, 100);
        }

        document.addEventListener("DOMContentLoaded", checkAdBlock, false);
    </script>
</head>
<body>
    <?php if ($isAdBlockerDetected): ?>
        <h1>Ad Blocker Detected!</h1>
        <p>Please consider disabling your ad blocker to support our content.</p>
    <?php else: ?>
        <h1>Welcome to Our Site!</h1>
        <p>Enjoy the content without restrictions.</p>
        <!-- Place your ad here -->
        <div id="ad-content">
            <p>Your ad content goes here.</p>
        </div>
    <?php endif; ?>
</body>
</html>
