<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Popunder Example with Delay</title>
    <script>
        // Array of random direct links
        const links = [
            'https://www.example.com',
            'https://www.anotherexample.com',
            'https://www.yetanotherexample.com',
            'https://www.somethingdifferent.com',
            'https://www.randomsite.com'
        ];

        // Function to open popunder
        function openPopunder() {
            // Select a random link from the array
            const randomLink = links[Math.floor(Math.random() * links.length)];

            // Open a new window/popunder
            const popunder = window.open(randomLink, '_blank');

            // Check for popunder support and focus on the original window
            if (popunder) {
                popunder.blur(); // Optional, move focus away from the new window
                window.focus(); // Bring focus back to the original window
            }
        }

        // Function to start opening popunders
        function startPopunders() {
            // Open the first popunder after a delay of 5 seconds
            setTimeout(openPopunder, 5000); // 5000 milliseconds = 5 seconds

            // Set interval to open popunder every 30 seconds after the initial delay
            setInterval(openPopunder, 30000); // 30000 milliseconds = 30 seconds
        }

        // Start opening popunders when the window loads
        window.onload = startPopunders;
    </script>
</head>
<body>
    <h1>Popunder Example with Delay</h1>
    <p>This page will open a popunder after a 5-second delay, then every 30 seconds.</p>
</body>
</html>
