<?php
// Check if the adblock cookie is set
$adblock_status = isset($_COOKIE['adblock']) ? $_COOKIE['adblock'] : 'unknown';

// If the adblock cookie is not set, we should use JavaScript to set it
if ($adblock_status === 'unknown') {
    echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            var adBlockEnabled = false;

            // Create a dummy ad element
            var ad = document.createElement("div");
            ad.innerHTML = "&nbsp;";
            ad.className = "adsbox";
            document.body.appendChild(ad);

            // Check if the ad element is hidden
            window.setTimeout(function() {
                if (ad.offsetHeight === 0) {
                    adBlockEnabled = true;
                }

                // Set a cookie based on the detection
                document.cookie = "adblock=" + (adBlockEnabled ? "enabled" : "disabled") + "; path=/";

                // Reload the page to apply the cookie
                window.location.reload();
            }, 100);
        });
    </script>';
    exit; // Stop further processing until the page reloads
} else {
    // Display message based on adblock status
    if ($adblock_status === 'enabled') {
        echo '<div class="adblock-message">AdBlocker is enabled. Please disable it to support us.</div>';
    } else {
        echo '<div class="no-adblock-message">Thank you for supporting us!</div>';
    }
}
?>


