<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Random Link Popup with Delay After First</title>
</head>
<body>

<script>
    // Single array for links storage
    const linksArray = [
        "https://example.com/link1",
        "https://example.com/link2",
        "https://example.com/link3",
        "https://example.com/link4",
        "https://example.com/link5"
    ];

    // Function to set a cookie
    function setCookie(name, value, minutes) {
        const expires = new Date();
        expires.setTime(expires.getTime() + (minutes * 60 * 1000));
        document.cookie = name + "=" + value + ";expires=" + expires.toUTCString() + ";path=/";
    }

    // Function to get a cookie by name
    function getCookie(name) {
        const nameEQ = name + "=";
        const ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) === ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }

    // Function to open popunder
    function openPopunder() {
        // Select a random link from the array
        const randomLink = linksArray[Math.floor(Math.random() * linksArray.length)];

        // Open a new window/popunder
        const popunder = window.open(randomLink, '_blank');

        // Check for popunder support and focus on the original window
        if (popunder) {
            popunder.blur();
            window.focus();
        }
    }

    // Track click sequence and prevent multiple popunders
    let isPopunderOpen = false;

    // Attach click event listener to open popunder on any click
    document.addEventListener('click', function() {
        // Get the current count of popunders opened per page, including query string
        const pagePath = location.pathname;
        const pageQuery = location.search;
        const cookieKey = 'popunderCount' + pagePath + pageQuery;

        let popunderCount = parseInt(getCookie(cookieKey)) || 0;

        // Allow opening popunders until we reach the limit of 3
        if (!isPopunderOpen && popunderCount < 1000) {
            isPopunderOpen = true;
            
            // Open popunder
            openPopunder();
            
            // Increment the popunder count and set it in cookie (expire after 1 minutes)
            popunderCount++;
            setCookie(cookieKey, popunderCount, 1);

            // Reset the flag after 10 seconds to allow for next click in sequence
            setTimeout(() => {
                isPopunderOpen = false;
            }, 1000); // 10000 milliseconds = 10 seconds
        }
    });
</script>

</body>
</html>
